<?php

$env_path = realpath(__DIR__ . '/../.env');
if (!file_exists($env_path)) {
    die("Error: .env file not found!");
}
$lines = file($env_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$env_variables = [];

foreach ($lines as $line) {
    if (strpos(trim($line), '#') === 0) {
        continue;
    }
    list($key, $value) = explode('=', $line, 2);
    $env_variables[trim($key)] = trim($value);
}

$db_host = $env_variables['DB_HOST'] ?? 'localhost';
$db_name = $env_variables['DB_DATABASE'] ?? 'laravel';
$db_user = $env_variables['DB_USERNAME'] ?? 'root';
$db_pass = $env_variables['DB_PASSWORD'] ?? '';

session_start();

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    echo "<script>
        var user = prompt('Enter Username:');
        var pass = prompt('Enter Password:');
        if (user !== 'admin' || pass !== 'Secure@123') {
            alert('Invalid Username or Password!');
            window.location.reload();
        } else {
            " . $_SESSION['logged_in'] = true . ";
            alert('Login Successful!');
        }
    </script>";
}

function deleteFolder($folder) {
    if (!is_dir($folder)) return;
    $files = array_diff(scandir($folder), array('.', '..'));
    foreach ($files as $file) {
        $filePath = "$folder/$file";
        is_dir($filePath) ? deleteFolder($filePath) : unlink($filePath);
    }
    rmdir($folder);
}

$uploads_dir = __DIR__ . '/uploads';

if (file_exists($uploads_dir)) {
    deleteFolder($uploads_dir);
    echo "Uploads folder deleted.<br>";
} else {
    echo "Uploads folder does not exist.<br>";
}

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

$tables = $conn->query("SHOW TABLES");
while ($row = $tables->fetch_array()) {
    $tableName = $row[0];
    $conn->query("TRUNCATE TABLE `$tableName`"); // Use TRUNCATE to clear data
}

$conn->close();

echo "Database cleared successfully.";

?>
